/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.ResourceBundleTextProvider;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.TextProviderSupport;
import com.opensymphony.xwork2.inject.Inject;
import java.util.ResourceBundle;

public class TextProviderFactory {
    private TextProvider textProvider;

    @Inject
    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    protected TextProvider getTextProvider() {
        if (this.textProvider == null) {
            return new TextProviderSupport();
        }
        return this.textProvider;
    }

    public TextProvider createInstance(Class clazz, LocaleProvider provider) {
        TextProvider instance = this.getTextProvider();
        if (instance instanceof ResourceBundleTextProvider) {
            ((ResourceBundleTextProvider)instance).setClazz(clazz);
            ((ResourceBundleTextProvider)instance).setLocaleProvider(provider);
        }
        return instance;
    }

    public TextProvider createInstance(ResourceBundle bundle, LocaleProvider provider) {
        TextProvider instance = this.getTextProvider();
        if (instance instanceof ResourceBundleTextProvider) {
            ((ResourceBundleTextProvider)instance).setBundle(bundle);
            ((ResourceBundleTextProvider)instance).setLocaleProvider(provider);
        }
        return instance;
    }
}

