/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.Component;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="property", tldBodyContent="empty", tldTagClass="org.apache.struts2.views.jsp.PropertyTag", description="Print out expression which evaluates against the stack")
public class Property
extends Component {
    private static final Log LOG = LogFactory.getLog(Property.class);
    private String defaultValue;
    private String value;
    private boolean escape = true;

    public Property(ValueStack stack) {
        super(stack);
    }

    @StrutsTagAttribute(description="The default value to be used if <u>value</u> attribute is null")
    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @StrutsTagAttribute(description=" Whether to escape HTML", type="Boolean", defaultValue="true")
    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    @StrutsTagAttribute(description="Value to be displayed", type="Object", defaultValue="&lt;top of stack&gt;")
    public void setValue(String value) {
        this.value = value;
    }

    public boolean start(Writer writer) {
        boolean result = super.start(writer);
        String actualValue = null;
        if (this.value == null) {
            this.value = "top";
        } else if (this.altSyntax() && this.value.startsWith("%{") && this.value.endsWith("}")) {
            this.value = this.value.substring(2, this.value.length() - 1);
        }
        actualValue = (String)this.getStack().findValue(this.value, String.class);
        try {
            if (actualValue != null) {
                writer.write(this.prepare(actualValue));
            } else if (this.defaultValue != null) {
                writer.write(this.prepare(this.defaultValue));
            }
        }
        catch (IOException e) {
            LOG.info((Object)("Could not print out value '" + this.value + "'"), (Throwable)e);
        }
        return result;
    }

    private String prepare(String value) {
        if (this.escape) {
            return TextUtils.htmlEncode((String)value);
        }
        return value;
    }
}

