/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.result;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.inject.Inject;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.portlet.result.PortletResult;
import org.apache.struts2.views.util.UrlHelper;

public class PortletActionRedirectResult
extends PortletResult {
    private static final long serialVersionUID = -7627388936683562557L;
    public static final String DEFAULT_PARAM = "actionName";
    protected String actionName;
    protected String namespace;
    protected String method;
    private Map<String, String> requestParameters = new LinkedHashMap<String, String>();
    private ActionMapper actionMapper;
    protected List<String> prohibitedResultParam = Arrays.asList("actionName", "namespace", "method", "encode", "parse", "location", "prependServletContext");

    public PortletActionRedirectResult() {
    }

    public PortletActionRedirectResult(String actionName) {
        this(null, actionName, null);
    }

    public PortletActionRedirectResult(String actionName, String method) {
        this(null, actionName, method);
    }

    public PortletActionRedirectResult(String namespace, String actionName, String method) {
        super(null);
        this.namespace = namespace;
        this.actionName = actionName;
        this.method = method;
    }

    @Inject
    public void setActionMapper(ActionMapper actionMapper) {
        this.actionMapper = actionMapper;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        this.actionName = this.conditionalParse(this.actionName, invocation);
        this.namespace = this.namespace == null ? invocation.getProxy().getNamespace() : this.conditionalParse(this.namespace, invocation);
        this.method = this.method == null ? "" : this.conditionalParse(this.method, invocation);
        String resultCode = invocation.getResultCode();
        if (resultCode != null) {
            ResultConfig resultConfig = (ResultConfig)invocation.getProxy().getConfig().getResults().get(resultCode);
            Map resultConfigParams = resultConfig.getParams();
            for (Map.Entry e : resultConfigParams.entrySet()) {
                if (this.prohibitedResultParam.contains(e.getKey())) continue;
                this.requestParameters.put(e.getKey().toString(), e.getValue() == null ? "" : this.conditionalParse(e.getValue().toString(), invocation));
            }
        }
        StringBuffer tmpLocation = new StringBuffer(this.actionMapper.getUriFromActionMapping(new ActionMapping(this.actionName, this.namespace, this.method, null)));
        UrlHelper.buildParametersString(this.requestParameters, tmpLocation, "&");
        this.setLocation(tmpLocation.toString());
        super.execute(invocation);
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public PortletActionRedirectResult addParameter(String key, Object value) {
        this.requestParameters.put(key, String.valueOf(value));
        return this;
    }
}

