/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.util.CreateIfNull;
import com.opensymphony.xwork2.util.Element;
import com.opensymphony.xwork2.util.Key;
import com.opensymphony.xwork2.util.KeyProperty;
import com.opensymphony.xwork2.util.ObjectTypeDeterminer;
import com.opensymphony.xwork2.util.XWorkConverter;
import java.beans.IntrospectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectTypeDeterminer
implements ObjectTypeDeterminer {
    protected static final Log LOG = LogFactory.getLog(DefaultObjectTypeDeterminer.class);
    public static final String KEY_PREFIX = "Key_";
    public static final String ELEMENT_PREFIX = "Element_";
    public static final String KEY_PROPERTY_PREFIX = "KeyProperty_";
    public static final String CREATE_IF_NULL_PREFIX = "CreateIfNull_";
    public static final String DEPRECATED_ELEMENT_PREFIX = "Collection_";

    @Override
    public Class getKeyClass(Class parentClass, String property) {
        Key annotation = this.getAnnotation(parentClass, property, Key.class);
        if (annotation != null) {
            return annotation.value();
        }
        Class clazz = this.getClass(parentClass, property, false);
        if (clazz != null) {
            return clazz;
        }
        return (Class)XWorkConverter.getInstance().getConverter(parentClass, KEY_PREFIX + property);
    }

    @Override
    public Class getElementClass(Class parentClass, String property, Object key) {
        Element annotation = this.getAnnotation(parentClass, property, Element.class);
        if (annotation != null) {
            return annotation.value();
        }
        Class clazz = this.getClass(parentClass, property, true);
        if (clazz != null) {
            return clazz;
        }
        clazz = (Class)XWorkConverter.getInstance().getConverter(parentClass, ELEMENT_PREFIX + property);
        if (clazz == null && (clazz = (Class)XWorkConverter.getInstance().getConverter(parentClass, DEPRECATED_ELEMENT_PREFIX + property)) != null) {
            LOG.info((Object)"The Collection_xxx pattern for collection type conversion is deprecated. Please use Element_xxx!");
        }
        return clazz;
    }

    @Override
    public String getKeyProperty(Class parentClass, String property) {
        KeyProperty annotation = this.getAnnotation(parentClass, property, KeyProperty.class);
        if (annotation != null) {
            return annotation.value();
        }
        return (String)XWorkConverter.getInstance().getConverter(parentClass, KEY_PROPERTY_PREFIX + property);
    }

    @Override
    public boolean shouldCreateIfNew(Class parentClass, String property, Object target, String keyProperty, boolean isIndexAccessed) {
        CreateIfNull annotation = this.getAnnotation(parentClass, property, CreateIfNull.class);
        if (annotation != null) {
            return annotation.value();
        }
        String configValue = (String)XWorkConverter.getInstance().getConverter(parentClass, CREATE_IF_NULL_PREFIX + property);
        if (configValue != null) {
            if (configValue.equals("true")) {
                return true;
            }
            if (configValue.equals("false")) {
                return false;
            }
        }
        return target instanceof Map || isIndexAccessed;
    }

    protected <T extends Annotation> T getAnnotation(Class parentClass, String property, Class<T> annotationClass) {
        T annotation = null;
        Field field = OgnlRuntime.getField((Class)parentClass, (String)property);
        if (field != null) {
            annotation = field.getAnnotation(annotationClass);
        }
        if (annotation == null) {
            annotation = this.getAnnotationFromSetter(parentClass, property, annotationClass);
        }
        if (annotation == null) {
            annotation = this.getAnnotationFromGetter(parentClass, property, annotationClass);
        }
        return annotation;
    }

    private <T extends Annotation> T getAnnotationFromGetter(Class parentClass, String property, Class<T> annotationClass) {
        try {
            Method getter = OgnlRuntime.getGetMethod(null, (Class)parentClass, (String)property);
            if (getter != null) {
                return getter.getAnnotation(annotationClass);
            }
        }
        catch (OgnlException ognle) {
        }
        catch (IntrospectionException ie) {
            // empty catch block
        }
        return null;
    }

    private <T extends Annotation> T getAnnotationFromSetter(Class parentClass, String property, Class<T> annotationClass) {
        try {
            Method setter = OgnlRuntime.getSetMethod(null, (Class)parentClass, (String)property);
            if (setter != null) {
                return setter.getAnnotation(annotationClass);
            }
        }
        catch (OgnlException ognle) {
        }
        catch (IntrospectionException ie) {
            // empty catch block
        }
        return null;
    }

    private Class getClass(Class parentClass, String property, boolean element) {
        block13: {
            try {
                Field field = OgnlRuntime.getField((Class)parentClass, (String)property);
                Type genericType = null;
                if (field != null) {
                    genericType = field.getGenericType();
                }
                if (genericType == null || !(genericType instanceof ParameterizedType)) {
                    try {
                        Method setter = OgnlRuntime.getSetMethod(null, (Class)parentClass, (String)property);
                        genericType = setter.getGenericParameterTypes()[0];
                    }
                    catch (OgnlException ognle) {
                    }
                    catch (IntrospectionException ie) {
                        // empty catch block
                    }
                }
                if (genericType == null || !(genericType instanceof ParameterizedType)) {
                    try {
                        Method getter = OgnlRuntime.getGetMethod(null, (Class)parentClass, (String)property);
                        genericType = getter.getGenericReturnType();
                    }
                    catch (OgnlException ognle) {
                    }
                    catch (IntrospectionException ie) {
                        // empty catch block
                    }
                }
                if (genericType instanceof ParameterizedType) {
                    ParameterizedType type = (ParameterizedType)genericType;
                    int index = element && type.getRawType().toString().contains(Map.class.getName()) ? 1 : 0;
                    Type resultType = type.getActualTypeArguments()[index];
                    if (resultType instanceof ParameterizedType) {
                        return resultType.getClass();
                    }
                    return (Class)resultType;
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block13;
                LOG.debug((Object)("Error while retrieving generic property class for property=" + property), (Throwable)e);
            }
        }
        return null;
    }
}

