/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.LoopTagSupport;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.ForEachSupport;

public abstract class ForEachSupport
extends LoopTagSupport {
    protected ForEachIterator items;
    protected Object rawItems;

    protected boolean hasNext() throws JspTagException {
        return this.items.hasNext();
    }

    protected Object next() throws JspTagException {
        return this.items.next();
    }

    protected void prepare() throws JspTagException {
        this.items = this.rawItems != null ? this.supportedTypeForEachIterator(this.rawItems) : this.beginEndForEachIterator();
        if (this.rawItems instanceof ResultSet && this.step != 1) {
            throw new JspTagException(Resources.getMessage("FOREACH_STEP_NO_RESULTSET"));
        }
    }

    public void release() {
        super.release();
        this.items = null;
        this.rawItems = null;
    }

    protected ForEachIterator supportedTypeForEachIterator(Object o) throws JspTagException {
        ForEachIterator items = o instanceof Object[] ? this.toForEachIterator((Object[])o) : (o instanceof boolean[] ? this.toForEachIterator((boolean[])o) : (o instanceof byte[] ? this.toForEachIterator((byte[])o) : (o instanceof char[] ? this.toForEachIterator((char[])o) : (o instanceof short[] ? this.toForEachIterator((short[])o) : (o instanceof int[] ? this.toForEachIterator((int[])o) : (o instanceof long[] ? this.toForEachIterator((long[])o) : (o instanceof float[] ? this.toForEachIterator((float[])o) : (o instanceof double[] ? this.toForEachIterator((double[])o) : (o instanceof Collection ? this.toForEachIterator((Collection)o) : (o instanceof Iterator ? this.toForEachIterator((Iterator)o) : (o instanceof Enumeration ? this.toForEachIterator((Enumeration)o) : (o instanceof Map ? this.toForEachIterator((Map)o) : (o instanceof ResultSet ? this.toForEachIterator((ResultSet)o) : (o instanceof String ? this.toForEachIterator((String)o) : this.toForEachIterator(o)))))))))))))));
        return items;
    }

    private ForEachIterator beginEndForEachIterator() {
        Integer[] ia = new Integer[this.end + 1];
        int i = 0;
        while (i <= this.end) {
            ia[i] = new Integer(i);
            ++i;
        }
        return new SimpleForEachIterator(Arrays.asList(ia).iterator());
    }

    protected ForEachIterator toForEachIterator(Object o) throws JspTagException {
        throw new JspTagException(Resources.getMessage("FOREACH_BAD_ITEMS"));
    }

    protected ForEachIterator toForEachIterator(Object[] a) {
        return new SimpleForEachIterator(Arrays.asList(a).iterator());
    }

    protected ForEachIterator toForEachIterator(boolean[] a) {
        Boolean[] wrapped = new Boolean[a.length];
        int i = 0;
        while (i < a.length) {
            wrapped[i] = new Boolean(a[i]);
            ++i;
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(byte[] a) {
        Byte[] wrapped = new Byte[a.length];
        int i = 0;
        while (i < a.length) {
            wrapped[i] = new Byte(a[i]);
            ++i;
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(char[] a) {
        Character[] wrapped = new Character[a.length];
        int i = 0;
        while (i < a.length) {
            wrapped[i] = new Character(a[i]);
            ++i;
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(short[] a) {
        Short[] wrapped = new Short[a.length];
        int i = 0;
        while (i < a.length) {
            wrapped[i] = new Short(a[i]);
            ++i;
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(int[] a) {
        Integer[] wrapped = new Integer[a.length];
        int i = 0;
        while (i < a.length) {
            wrapped[i] = new Integer(a[i]);
            ++i;
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(long[] a) {
        Long[] wrapped = new Long[a.length];
        int i = 0;
        while (i < a.length) {
            wrapped[i] = new Long(a[i]);
            ++i;
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(float[] a) {
        Float[] wrapped = new Float[a.length];
        int i = 0;
        while (i < a.length) {
            wrapped[i] = new Float(a[i]);
            ++i;
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(double[] a) {
        Double[] wrapped = new Double[a.length];
        int i = 0;
        while (i < a.length) {
            wrapped[i] = new Double(a[i]);
            ++i;
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(Collection c) {
        return new SimpleForEachIterator(c.iterator());
    }

    protected ForEachIterator toForEachIterator(Iterator i) {
        return new SimpleForEachIterator(i);
    }

    protected ForEachIterator toForEachIterator(Enumeration e) {
        class EnumerationAdapter
        implements ForEachIterator {
            private Enumeration e;
            private final /* synthetic */ ForEachSupport this$0;

            public EnumerationAdapter(ForEachSupport this$0, Enumeration e) {
                this.this$0 = this$0;
                this.e = e;
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public Object next() {
                return this.e.nextElement();
            }
        }
        return new EnumerationAdapter(this, e);
    }

    protected ForEachIterator toForEachIterator(Map m) {
        return new SimpleForEachIterator(m.entrySet().iterator());
    }

    protected ForEachIterator toForEachIterator(ResultSet rs) throws JspTagException {
        class ResultSetAdapter
        implements ForEachIterator {
            private ResultSet rs;
            private final /* synthetic */ ForEachSupport this$0;

            public ResultSetAdapter(ForEachSupport this$0, ResultSet rs) {
                this.this$0 = this$0;
                this.rs = rs;
            }

            public boolean hasNext() throws JspTagException {
                try {
                    return !this.rs.isLast();
                }
                catch (SQLException ex) {
                    throw new JspTagException(ex.getMessage());
                }
            }

            public Object next() throws JspTagException {
                try {
                    this.rs.next();
                    return this.rs;
                }
                catch (SQLException ex) {
                    throw new JspTagException(ex.getMessage());
                }
            }
        }
        return new ResultSetAdapter(this, rs);
    }

    protected ForEachIterator toForEachIterator(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        return this.toForEachIterator(st);
    }

    protected static interface ForEachIterator {
        public boolean hasNext() throws JspTagException;

        public Object next() throws JspTagException;
    }

    protected class SimpleForEachIterator
    implements ForEachIterator {
        private Iterator i;

        public SimpleForEachIterator(Iterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return this.i.next();
        }
    }
}

