/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.validators;

import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.DefaultActionInvocation;
import com.opensymphony.xwork2.DefaultActionProxy;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.UnknownHandler;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.ValidationAwareSupport;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.ApplicationMap;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.RequestMap;
import org.apache.struts2.dispatcher.SessionMap;
import uk.ltd.getahead.dwr.WebContextFactory;

public class DWRValidator {
    private static final Log LOG = LogFactory.getLog(DWRValidator.class);

    public ValidationAwareSupport doPost(String namespace, String action, Map params) throws Exception {
        HttpServletRequest req = WebContextFactory.get().getHttpServletRequest();
        ServletContext servletContext = WebContextFactory.get().getServletContext();
        HttpServletResponse res = WebContextFactory.get().getHttpServletResponse();
        HashMap requestParams = new HashMap(req.getParameterMap());
        if (params != null) {
            requestParams.putAll(params);
        } else {
            params = requestParams;
        }
        RequestMap requestMap = new RequestMap(req);
        SessionMap session = new SessionMap(req);
        ApplicationMap application = new ApplicationMap(servletContext);
        Dispatcher du = Dispatcher.getInstance();
        HashMap<String, Object> ctx = du.createContextMap(requestMap, params, session, application, req, res, servletContext);
        try {
            Configuration cfg = du.getConfigurationManager().getConfiguration();
            ValidatorActionProxy proxy = new ValidatorActionProxy(namespace, action, ctx);
            cfg.getContainer().inject((Object)proxy);
            proxy.prepare();
            proxy.execute();
            Object a = proxy.getAction();
            if (a instanceof ValidationAware) {
                ValidationAware aware = (ValidationAware)a;
                ValidationAwareSupport vas = new ValidationAwareSupport();
                vas.setActionErrors(aware.getActionErrors());
                vas.setActionMessages(aware.getActionMessages());
                vas.setFieldErrors(aware.getFieldErrors());
                return vas;
            }
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while trying to validate", (Throwable)e);
            return null;
        }
    }

    public static class ValidatorActionProxy
    extends DefaultActionProxy {
        private static final long serialVersionUID = 5754781916414047963L;

        protected ValidatorActionProxy(String namespace, String actionName, Map extraContext) throws Exception {
            super(namespace, actionName, extraContext, false, true);
        }

        public void prepare() throws Exception {
            super.prepare();
            this.invocation = new ValidatorActionInvocation(this.objectFactory, this.unknownHandler, (ActionProxy)this, this.extraContext);
        }
    }

    public static class ValidatorActionInvocation
    extends DefaultActionInvocation {
        private static final long serialVersionUID = -7645433725470191275L;

        protected ValidatorActionInvocation(ObjectFactory objectFactory, UnknownHandler handler, ActionProxy proxy, Map extraContext) throws Exception {
            super(objectFactory, handler, proxy, extraContext, true);
        }

        protected String invokeAction(Object action, ActionConfig actionConfig) throws Exception {
            return "none";
        }
    }
}

